/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.network.packet.server;

import cofh.core.CoFHCore;
import cofh.lib.block.entity.ITilePacketHandler;
import cofh.lib.network.packet.IPacketServer;
import cofh.lib.network.packet.PacketBase;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class TileConfigPacket
extends PacketBase
implements IPacketServer {
    protected BlockPos pos;
    protected FriendlyByteBuf buffer;

    public TileConfigPacket() {
        super(32, CoFHCore.PACKET_HANDLER);
    }

    @Override
    public void handleServer(ServerPlayer player) {
        Level world = player.f_19853_;
        if (!world.m_46749_(this.pos)) {
            return;
        }
        BlockEntity tile = world.m_7702_(this.pos);
        if (tile instanceof ITilePacketHandler) {
            ((ITilePacketHandler)tile).handleConfigPacket(this.buffer);
        }
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.writeBytes((ByteBuf)this.buffer);
    }

    @Override
    public void read(FriendlyByteBuf buf) {
        this.buffer = buf;
        this.pos = this.buffer.m_130135_();
    }

    public static void sendToServer(ITilePacketHandler tile) {
        TileConfigPacket packet = new TileConfigPacket();
        packet.pos = tile.pos();
        packet.buffer = tile.getConfigPacket(new FriendlyByteBuf(Unpooled.buffer()));
        packet.sendToServer();
    }
}

